import React, { useCallback, useMemo, memo } from "react";
import BottomSheet, {
    BottomSheetBackdrop,
    useBottomSheetSpringConfigs,
    BottomSheetHandle,
    BottomSheetFlatList,
} from "@gorhom/bottom-sheet";
import { bottomSheetStyles } from "./bottomSheet.style";

const CustomBottomSheet = ({
    style = {},
    bsRef,
    snapPoint = [300],
    bgColor = "#FFFFFF",
    indicatorColor,
    children,
    isHeaderComponent = false,
    headerComponent,
    handleLoadMoreOrders = () => { },
}) => {

    const bottomSheetStyle = bottomSheetStyles(indicatorColor, bgColor);

    const renderBackdrop = useCallback((props) => {
        return (
            <BottomSheetBackdrop
                {...props}
                appearsOnIndex={0}
                disappearsOnIndex={-1}
                opacity={0.2}
            />
        );
    }, []);

    const animationConfigs = useBottomSheetSpringConfigs({
        damping: 80,
        overshootClamping: true,
        restDisplacementThreshold: 0.1,
        restSpeedThreshold: 0.1,
        stiffness: 700,
    });
    const renderBottomSheetHandle = () => {
        return (
            <BottomSheetHandle
                indicatorStyle={bottomSheetStyle.bottomSheetIndicator}
            />
        );
    };

    const handleChange = (index) => {};

    return (
        <BottomSheet
            onChange={handleChange}
            ref={bsRef}
            index={-1}
            enablePanDownToClose={true}
            backdropComponent={renderBackdrop}
            animationConfigs={animationConfigs}
            handleComponent={renderBottomSheetHandle}
            backgroundStyle={bottomSheetStyle.bottomSheet}
            enableDynamicSizing={isHeaderComponent ? false : true}
            snapPoints={snapPoint}
        >
                {isHeaderComponent &&
                    typeof headerComponent == "object" &&
                    headerComponent}
                <BottomSheetFlatList
                    showsVerticalScrollIndicator={false}
                    keyboardShouldPersistTaps="always"
                    contentContainerStyle={[
                        bottomSheetStyle.contentContainer,
                        style,
                    ]}
                    ListHeaderComponent={() => <>{children}</>}
                    scrollEnabled={true}
                    onEndReachedThreshold={0.5}
                    onEndReached={handleLoadMoreOrders}
                />
        </BottomSheet>
    );
};

export default memo(CustomBottomSheet);
